/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.client.column;

import java.sql.SQLDataException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.Configuration;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.DataType;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.ReadableByteBuf;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.client.column.BlobColumn;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.Geometry;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.GeometryCollection;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.LineString;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.MultiLineString;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.MultiPoint;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.MultiPolygon;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.Point;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.Polygon;

public class GeometryColumn
extends BlobColumn {
    public GeometryColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        if (conf.geometryDefaultType() != null && "default".equals(conf.geometryDefaultType())) {
            if (this.extTypeName != null) {
                switch (this.extTypeName) {
                    case "point": {
                        return Point.class.getName();
                    }
                    case "linestring": {
                        return LineString.class.getName();
                    }
                    case "polygon": {
                        return Polygon.class.getName();
                    }
                    case "multipoint": {
                        return MultiPoint.class.getName();
                    }
                    case "multilinestring": {
                        return MultiLineString.class.getName();
                    }
                    case "multipolygon": {
                        return MultiPolygon.class.getName();
                    }
                    case "geometrycollection": {
                        return GeometryCollection.class.getName();
                    }
                }
            }
            return GeometryCollection.class.getName();
        }
        return "byte[]";
    }

    @Override
    public int getColumnType(Configuration conf) {
        return -3;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        if (this.extTypeName != null) {
            return this.extTypeName.toUpperCase(Locale.ROOT);
        }
        return "GEOMETRY";
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        if (conf.geometryDefaultType() != null && "default".equals(conf.geometryDefaultType())) {
            buf.skip(4);
            return Geometry.getGeometry(buf, length - 4, this);
        }
        byte[] arr = new byte[length];
        buf.readBytes(arr);
        return arr;
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, int length) throws SQLDataException {
        return this.getDefaultText(conf, buf, length);
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, int length, Calendar cal) throws SQLDataException {
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

